/*
 * Decompiled with CFR 0.152.
 */
package jeresources.entry;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import jeresources.collection.TradeList;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.class_1799;
import net.minecraft.class_3853;
import net.minecraft.class_3988;

public abstract class AbstractVillagerEntry<T extends class_3988> {
    private final List<TradeList> tradeList = new LinkedList<TradeList>();
    protected T entity;

    public AbstractVillagerEntry(Int2ObjectMap<class_3853.class_1652[]> itemListings) {
        this.addITradeLists(itemListings);
    }

    public void addITradeLists(Int2ObjectMap<class_3853.class_1652[]> itemListings) {
        for (int i = 1; i < itemListings.size() + 1; ++i) {
            class_3853.class_1652[] levelList = (class_3853.class_1652[])itemListings.get(i);
            TradeList trades = this.tradeList.size() > i ? this.tradeList.get(i) : new TradeList((class_3988)this.entity);
            trades.addITradeList(levelList);
            this.tradeList.add(trades);
        }
    }

    public TradeList getVillagerTrades(int level) {
        if (this.tradeList.size() > level) {
            return this.tradeList.get(level);
        }
        return new TradeList((class_3988)this.entity);
    }

    public List<class_1799> getInputs() {
        LinkedList<class_1799> list = new LinkedList<class_1799>();
        for (List list2 : this.tradeList) {
            for (TradeList.Trade trade : list2) {
                list.add(trade.getMinCostA());
                if (trade.getMinCostB().method_7960()) continue;
                list.add(trade.getMinCostB());
            }
        }
        return list;
    }

    public List<class_1799> getOutputs() {
        LinkedList<class_1799> list = new LinkedList<class_1799>();
        for (List list2 : this.tradeList) {
            list.addAll(list2.stream().map(TradeList.Trade::getMinResult).collect(Collectors.toList()));
        }
        return list;
    }

    public int getMaxLevel() {
        return this.tradeList.size();
    }

    public abstract String getName();

    public abstract String getDisplayName();

    public List<Integer> getPossibleLevels(IFocus<class_1799> focus) {
        ArrayList<Integer> levels = new ArrayList<Integer>();
        for (int i = 0; i < this.tradeList.size(); ++i) {
            if (this.tradeList.get(i) == null || this.tradeList.get(i).getFocusedList(focus).size() <= 0) continue;
            levels.add(i);
        }
        return levels;
    }

    public abstract T getVillagerEntity();

    public abstract List<class_1799> getPois();

    public abstract boolean hasPois();

    public abstract boolean hasLevels();
}

